/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;

public class OsUtils {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    public static final int DEFAULT_WIDTH = 120;
    public static final String[] WINDOWS_TERM_WIDTH_COMMAND = new String[]{"PowerShell", "-Command", "& {(get-host).UI.RawUI.WindowSize.Width}"};
    public static final String[] UNIX_TERM_WIDTH_COMMAND = new String[]{"sh", "-c", "tput cols 2> /dev/tty"};
    public static final String LINE_SEPARATOR = String.format("%n", new Object[0]);

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    public static boolean isWindows() {
        return OS.startsWith("win");
    }

    public static Optional<Integer> getTerminalWidth() {
        if (!OsUtils.isUnix()) {
            return Optional.empty();
        }
        String[] cmd = UNIX_TERM_WIDTH_COMMAND;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            int exitCode = p.waitFor();
            if (exitCode == 0) {
                return Optional.of(Integer.parseInt(new BufferedReader(new InputStreamReader(p.getInputStream())).readLine()));
            }
        }
        catch (IOException | InterruptedException | RuntimeException exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static String fixPathSep(String path) {
        return path.replace("/", File.separator);
    }

    public static String fps(String path) {
        return OsUtils.fixPathSep(path);
    }

    public static String getOS() {
        return OS;
    }
}

