/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.LicenseInfo;
import net.sourceforge.plantuml.version.Magic;
import net.sourceforge.plantuml.version.Version;

public class PSystemKeygen
extends AbstractPSystem {
    private final String key;

    public PSystemKeygen(String key) {
        this.key = key;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                try {
                    PSystemKeygen.this.drawInternal(ug);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Genkey)");
    }

    private void drawInternal(UGraphic ug) throws IOException {
        if (this.key.length() == 0) {
            this.drawFlash(ug);
            return;
        }
        LicenseInfo info = LicenseInfo.retrieve(this.key);
        if (info.isNone()) {
            this.drawFlash(ug);
            return;
        }
        ArrayList<String> strings = this.header();
        strings.add("<u>Provided license information</u>:");
        License.addLicenseInfo(strings, info);
        strings.add(" ");
        strings.add("========================================================================");
        try {
            LicenseInfo.persistMe(this.key);
        }
        catch (BackingStoreException e) {
            strings.add("<i>Error: Cannot store license key.</i>");
        }
        LicenseInfo installed = LicenseInfo.retrieveSlow();
        if (installed.isNone()) {
            strings.add("No license currently installed.");
            strings.add(" ");
            strings.add("<b>Please copy license.txt to one of those files</b>:");
            for (File f : LicenseInfo.fileCandidates()) {
                strings.add(f.getAbsolutePath());
            }
            strings.add(" ");
        } else {
            strings.add("<u>Installed license</u>:");
            License.addLicenseInfo(strings, installed);
            strings.add(" ");
        }
        TextBlockBackcolored disp = GraphicStrings.createBlackOnWhite(strings);
        disp.drawU(ug);
    }

    private ArrayList<String> header() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        strings.add("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        strings.add("Loaded from " + Version.getJarPath());
        strings.add(" ");
        return strings;
    }

    public void drawFlash(UGraphic ug) throws IOException {
        ArrayList<String> strings = this.header();
        strings.add("To get your <i>Professional Edition License</i>,");
        strings.add("please send this flashcode to <b>plantuml@gmail.com</b> :");
        TextBlockBackcolored disp = GraphicStrings.createBlackOnWhite(strings);
        disp.drawU(ug);
        ug = ug.apply(new UTranslate(0.0, disp.calculateDimension(ug.getStringBounder()).getHeight()));
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        BufferedImage im = utils.exportFlashcode(Version.versionString() + "\n" + SignatureUtils.toHexString(Magic.signature()));
        UImage flash = new UImage(im).scaleNearestNeighbor(4.0);
        ug.draw(flash);
        ug = ug.apply(new UTranslate(0.0, flash.getHeight()));
        LicenseInfo info = LicenseInfo.retrieveSlow();
        if (!info.isNone()) {
            strings.clear();
            strings.add("<u>Installed license</u>:");
            License.addLicenseInfo(strings, info);
            strings.add(" ");
            disp = GraphicStrings.createBlackOnWhite(strings);
            disp.drawU(ug);
        }
    }
}

