/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.dedication.QBlock;
import net.sourceforge.plantuml.version.Magic;

public class LicenseInfo {
    private static final Preferences prefs = Preferences.userNodeForPackage(LicenseInfo.class);
    private static final LicenseInfo NONE = new LicenseInfo();
    public static final int POS_TYPE = 2;
    public static final int POS_SIGNATURE = 10;
    public static final int POS_GENERATION = 100;
    public static final int POS_EXPIRATION = 108;
    public static final int POS_OWNER = 128;
    private final long generationDate;
    private final long expirationDate;
    private final String owner;
    private static LicenseInfo cache;

    private LicenseInfo() {
        this.expirationDate = 0L;
        this.generationDate = 0L;
        this.owner = null;
    }

    private LicenseInfo(Magic magic) throws NoSuchAlgorithmException, IOException {
        String signature = SignatureUtils.toHexString(magic.get(10, 64));
        String local = SignatureUtils.toHexString(Magic.signature());
        if (!local.equals(signature)) {
            throw new IOException();
        }
        int type = magic.getByte(Magic.signature(), 2);
        this.generationDate = LicenseInfo.bytesToLong(magic.get(100, 8));
        this.expirationDate = LicenseInfo.bytesToLong(magic.get(108, 8));
        this.owner = magic.getString(128);
    }

    public static long bytesToLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    public static void persistMe(String key) throws BackingStoreException {
        prefs.sync();
        prefs.put("license", key);
    }

    public static synchronized LicenseInfo retrieveQuick() {
        if (cache == null) {
            return LicenseInfo.retrieveSlow();
        }
        return cache;
    }

    public static synchronized LicenseInfo retrieveSlow() {
        cache = NONE;
        String key = prefs.get("license", "");
        if (key.length() > 0 && (cache = LicenseInfo.setIfValid(LicenseInfo.retrieve(key), cache)).isValid()) {
            return cache;
        }
        for (File f : LicenseInfo.fileCandidates()) {
            try {
                LicenseInfo result;
                if (!f.exists() || !f.canRead() || !(cache = LicenseInfo.setIfValid(result = LicenseInfo.retrieve(f), cache)).isValid()) continue;
                return cache;
            }
            catch (IOException e) {
                Log.info("Error " + e);
            }
        }
        return cache;
    }

    private static LicenseInfo setIfValid(LicenseInfo value, LicenseInfo def) {
        if (value.isValid() || def.isNone()) {
            return value;
        }
        return def;
    }

    private static LicenseInfo retrieve(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        String s = br.readLine();
        br.close();
        LicenseInfo result = LicenseInfo.retrieve(s);
        if (result != null) {
            Log.info("Reading license from " + f.getAbsolutePath());
        }
        return result;
    }

    public static LicenseInfo retrieve(String key) {
        if (key.matches("^[0-9a-z]+$")) {
            try {
                BigInteger lu = new BigInteger(key, 36);
                QBlock qb2 = new QBlock(lu);
                QBlock qb3 = qb2.change(Dedication.E, Dedication.N);
                Magic magic = qb3.toMagic();
                String sig = SignatureUtils.toHexString(Magic.signature());
                magic.xor(SignatureUtils.getSHA512raw(SignatureUtils.salting(sig, Magic.getSalt(sig))));
                return new LicenseInfo(magic);
            }
            catch (Exception e) {
                Log.info("Error " + e);
            }
        }
        return NONE;
    }

    public static Collection<File> fileCandidates() {
        String[] classpathEntries;
        TreeSet<File> result = new TreeSet<File>();
        String classpath = System.getProperty("java.class.path");
        for (String s : classpathEntries = classpath.split(File.pathSeparator)) {
            File dir = new File(s);
            if (dir.isFile()) {
                dir = dir.getParentFile();
            }
            if (!dir.isDirectory()) continue;
            result.add(new File(dir, "license.txt"));
        }
        return result;
    }

    public static void main(String[] args) {
        LicenseInfo info = LicenseInfo.retrieveSlow();
        System.err.println("valid=" + info.isValid());
        System.err.println("info=" + info.owner);
    }

    public final Date getGenerationDate() {
        return new Date(this.generationDate);
    }

    public final Date getExpirationDate() {
        return new Date(this.expirationDate);
    }

    public final String getOwner() {
        return this.owner;
    }

    public boolean isNone() {
        return this.owner == null;
    }

    public boolean isValid() {
        return this.owner != null && System.currentTimeMillis() <= this.expirationDate;
    }

    public boolean hasExpired() {
        return this.owner != null && System.currentTimeMillis() > this.expirationDate;
    }
}

