/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.DaysAsDates;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.SubjectPattern;
import net.sourceforge.plantuml.project3.VerbIsOrAre;
import net.sourceforge.plantuml.project3.VerbIsOrAreNamed;
import net.sourceforge.plantuml.project3.VerbPattern;

public class SubjectDaysAsDates
implements SubjectPattern {
    @Override
    public Collection<VerbPattern> getVerbs() {
        return Arrays.asList(new VerbIsOrAre(), new VerbIsOrAreNamed());
    }

    @Override
    public IRegex toRegex() {
        return new RegexOr(this.regexTo(), this.regexAnd());
    }

    private IRegex regexTo() {
        return new RegexConcat(new RegexLeaf("YEAR1", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH1", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY1", "([\\d]{1,2})"), new RegexLeaf("[%s]+to[%s]+"), new RegexLeaf("YEAR2", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH2", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY2", "([\\d]{1,2})"));
    }

    private IRegex regexAnd() {
        return new RegexConcat(new RegexLeaf("YEAR3", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH3", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY3", "([\\d]{1,2})"), new RegexLeaf("[%s]+and[%s]+"), new RegexLeaf("COUNT", "([\\d]+)"), new RegexLeaf("[%s]+days?"));
    }

    @Override
    public Subject getSubject(GanttDiagram project, RegexResult arg) {
        String count = arg.get("COUNT", 0);
        if (count == null) {
            DayAsDate date1 = this.getDate(arg, "1");
            DayAsDate date2 = this.getDate(arg, "2");
            return new DaysAsDates(date1, date2);
        }
        DayAsDate date3 = this.getDate(arg, "3");
        int nb = Integer.parseInt(count);
        return new DaysAsDates(project, date3, nb);
    }

    private DayAsDate getDate(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("DAY" + suffix, 0));
        int month = Integer.parseInt(arg.get("MONTH" + suffix, 0));
        int year = Integer.parseInt(arg.get("YEAR" + suffix, 0));
        return DayAsDate.create(year, month, day);
    }
}

