/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.Preprocessor;
import net.sourceforge.plantuml.preproc.PreprocessorInclude;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineInstrumented;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.Sub;

public class SubPreprocessor
extends ReadLineInstrumented
implements ReadLine {
    private static final String ID = "[A-Za-z_][A-Za-z_0-9]*";
    private static final Pattern2 includeSubPattern = MyPattern.cmpile("^[%s]*!includesub[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 startsub = MyPattern.cmpile("^[%s]*!startsub[%s]+([A-Za-z_][A-Za-z_0-9]*)");
    private static final Pattern2 endsub = MyPattern.cmpile("^[%s]*!endsub[%s]*");
    private final ReadLine source;
    private final Defines defines;
    private final DefinitionsContainer definitionsContainer;
    private final String charset;
    private final Map<String, Sub> subs = new HashMap<String, Sub>();
    private final List<String> config;
    private Sub learningSub;
    private ReadLine includedSub;

    public SubPreprocessor(List<String> config, String charset, Defines defines, DefinitionsContainer definitionsContainer, ReadLine source) {
        this.config = config;
        this.source = source;
        this.charset = charset;
        this.defines = defines;
        this.definitionsContainer = definitionsContainer;
    }

    @Override
    CharSequence2 readLineInst() throws IOException {
        CharSequence2 s;
        if (this.includedSub != null) {
            s = this.includedSub.readLine();
            if (s != null) {
                this.eventuallyLearn(s);
                return s;
            }
            this.includedSub = null;
        }
        if ((s = this.source.readLine()) == null) {
            return null;
        }
        Matcher2 m1 = includeSubPattern.matcher(s);
        if (m1.find()) {
            return this.manageIncludeSub(s, m1);
        }
        Matcher2 m = startsub.matcher(s);
        if (m.find()) {
            return this.manageStartsub(m);
        }
        m = endsub.matcher(s);
        if (m.find()) {
            return this.manageEndsub(m);
        }
        this.eventuallyLearn(s);
        return s;
    }

    private void eventuallyLearn(CharSequence2 s) {
        if (this.learningSub != null) {
            this.learningSub.add(s);
        }
    }

    private CharSequence2 manageIncludeSub(CharSequence2 s, Matcher2 m) throws IOException {
        String name = m.group(1);
        int idx = name.indexOf(33);
        if (idx != -1) {
            String filename = name.substring(0, idx);
            String blocname = name.substring(idx + 1);
            File f = FileSystem.getInstance().getFile(PreprocessorInclude.withEnvironmentVariable(filename));
            if (!f.exists() || f.isDirectory()) {
                return s.withErrorPreprocessor("Cannot include " + f.getAbsolutePath());
            }
            Preprocessor data = new Preprocessor(this.config, this.getReaderInclude(s, f), this.charset, this.defines, null, this.definitionsContainer);
            while (data.readLine() != null) {
            }
            data.close();
            this.includedSub = data.getSub(blocname).getReadLine(s.getLocation());
        } else {
            this.includedSub = this.getSub(name).getReadLine(s.getLocation());
        }
        return this.readLine();
    }

    private ReadLine getReaderInclude(CharSequence2 s, File f) {
        try {
            if (this.charset == null) {
                Log.info("Using default charset");
                return ReadLineReader.create(new FileReader(f), f.getAbsolutePath(), s.getLocation());
            }
            Log.info("Using charset " + this.charset);
            return ReadLineReader.create(new InputStreamReader((InputStream)new FileInputStream(f), this.charset), f.getAbsolutePath(), s.getLocation());
        }
        catch (IOException e) {
            return new ReadLineSimple(s, e.toString());
        }
    }

    private CharSequence2 manageStartsub(Matcher2 m) throws IOException {
        String name = m.group(1);
        this.learningSub = this.getSub(name);
        return this.readLine();
    }

    private CharSequence2 manageEndsub(Matcher2 m) throws IOException {
        this.learningSub = null;
        return this.readLine();
    }

    Sub getSub(String name) {
        Sub result = this.subs.get(name);
        if (result == null) {
            result = new Sub(name);
            this.subs.put(name, result);
        }
        return result;
    }

    @Override
    void closeInst() throws IOException {
        this.source.close();
    }
}

