/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.utils.StartUtils;

public class StartDiagramExtractReader
implements ReadLine {
    private final ReadLine raw;
    private boolean finished = false;

    public StartDiagramExtractReader(CharSequence2 s, File f, String uid, String charset) {
        this(StartDiagramExtractReader.getReadLine(s, f, charset), uid);
    }

    public StartDiagramExtractReader(CharSequence2 s, URL url, String uid, String charset) {
        this(StartDiagramExtractReader.getReadLine(s, url, charset), uid);
    }

    public StartDiagramExtractReader(CharSequence2 s, InputStream is, String desc) {
        this(StartDiagramExtractReader.getReadLine(s, is, desc), null);
    }

    private StartDiagramExtractReader(ReadLine raw, String suf) {
        int bloc = 0;
        String uid = null;
        if (suf != null && suf.matches("\\d+")) {
            bloc = Integer.parseInt(suf);
        } else {
            uid = suf;
        }
        if (bloc < 0) {
            bloc = 0;
        }
        this.raw = raw;
        CharSequence2 s = null;
        try {
            while ((s = raw.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(s) || !this.checkUid(uid, s)) continue;
                if (bloc == 0) {
                    return;
                }
                --bloc;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error " + e);
        }
        this.finished = true;
    }

    private boolean checkUid(String uid, CharSequence2 s) {
        if (uid == null) {
            return true;
        }
        return s.toString().matches(".*id=" + uid + "\\W.*");
    }

    private static ReadLine getReadLine(CharSequence2 s, File f, String charset) {
        try {
            if (charset == null) {
                Log.info("Using default charset");
                return new UncommentReadLine(ReadLineReader.create(new FileReader(f), f.getAbsolutePath()));
            }
            Log.info("Using charset " + charset);
            return new UncommentReadLine(ReadLineReader.create(new InputStreamReader((InputStream)new FileInputStream(f), charset), f.getAbsolutePath()));
        }
        catch (IOException e) {
            return new ReadLineSimple(s, e.toString());
        }
    }

    private static ReadLine getReadLine(CharSequence2 s, InputStream is, String description) {
        return new UncommentReadLine(ReadLineReader.create(new InputStreamReader(is), description));
    }

    private static ReadLine getReadLine(CharSequence2 s, URL url, String charset) {
        try {
            if (charset == null) {
                Log.info("Using default charset");
                return new UncommentReadLine(ReadLineReader.create(new InputStreamReader(url.openStream()), url.toString()));
            }
            Log.info("Using charset " + charset);
            return new UncommentReadLine(ReadLineReader.create(new InputStreamReader(url.openStream(), charset), url.toString()));
        }
        catch (IOException e) {
            return new ReadLineSimple(s, e.toString());
        }
    }

    public static boolean containsStartDiagram(CharSequence2 s, File f, String charset) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(s, f, charset);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    public static boolean containsStartDiagram(CharSequence2 s, URL url, String charset) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(s, url, charset);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    public static boolean containsStartDiagram(CharSequence2 s, InputStream is, String description) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(s, is, description);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    private static boolean containsStartDiagram(ReadLine r) throws IOException {
        try {
            CharSequence2 s = null;
            while ((s = r.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(s)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        return false;
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        CharSequence2 result = this.raw.readLine();
        if (result != null && StartUtils.isArobaseEndDiagram(result)) {
            this.finished = true;
            return null;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.raw.close();
    }
}

