/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SvgString;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.math.AsciiMath;
import net.sourceforge.plantuml.math.LatexBuilder;
import net.sourceforge.plantuml.math.ScientificEquation;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class ScientificEquationSafe {
    private final ScientificEquation equation;
    private final String formula;
    private ImageData dimSvg;

    private ScientificEquationSafe(String formula, ScientificEquation equation) {
        this.formula = formula;
        this.equation = equation;
    }

    public static ScientificEquationSafe fromAsciiMath(String formula) {
        try {
            return new ScientificEquationSafe(formula, new AsciiMath(formula));
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.info("Error parsing " + formula);
            return new ScientificEquationSafe(formula, null);
        }
    }

    public static ScientificEquationSafe fromLatex(String formula) {
        try {
            return new ScientificEquationSafe(formula, new LatexBuilder(formula));
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.info("Error parsing " + formula);
            return new ScientificEquationSafe(formula, null);
        }
    }

    public SvgString getSvg(double scale, Color foregroundColor, Color backgroundColor) {
        try {
            SvgString svg = this.equation.getSvg(scale, foregroundColor, backgroundColor);
            this.dimSvg = new ImageDataSimple(this.equation.getDimension());
            return svg;
        }
        catch (Exception e) {
            this.printTrace(e);
            ImageBuilder imageBuilder = this.getRollback();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.dimSvg = imageBuilder.writeImageTOBEMOVED(new FileFormatOption(FileFormat.SVG), 42L, baos);
            }
            catch (IOException e1) {
                return null;
            }
            return new SvgString(new String(baos.toByteArray()), scale);
        }
    }

    public BufferedImage getImage(double scale, Color foregroundColor, Color backgroundColor) {
        try {
            return this.equation.getImage(scale, foregroundColor, backgroundColor);
        }
        catch (Exception e) {
            this.printTrace(e);
            ImageBuilder imageBuilder = this.getRollback();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                imageBuilder.writeImageTOBEMOVED(new FileFormatOption(FileFormat.PNG), 42L, baos);
                return ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (IOException e1) {
                return null;
            }
        }
    }

    private void printTrace(Exception e) {
        System.err.println("formula=" + this.formula);
        if (this.formula != null) {
            System.err.println("Latex=" + this.equation.getSource());
        }
        e.printStackTrace();
    }

    private ImageBuilder getRollback() {
        TextBlockBackcolored block2 = GraphicStrings.createBlackOnWhiteMonospaced(Arrays.asList(this.formula));
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, null, null, null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(block2);
        return imageBuilder;
    }

    public ImageData export(OutputStream os, FileFormatOption fileFormat, float scale, Color foregroundColor, Color backgroundColor) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.PNG) {
            BufferedImage image = this.getImage(scale, foregroundColor, backgroundColor);
            ImageIO.write((RenderedImage)image, "png", os);
            return new ImageDataSimple(image.getWidth(), image.getHeight());
        }
        if (fileFormat.getFileFormat() == FileFormat.SVG) {
            os.write(this.getSvg(1.0, foregroundColor, backgroundColor).getSvg(true).getBytes());
            return this.dimSvg;
        }
        return null;
    }
}

