/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.test.functions;

import java.util.List;
import java.util.function.BiFunction;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.FunctionContext;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.FunctionCallOptions;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class SimpleMathFunction
implements IdentifiedFunction,
RealizableFunction {
    public final String id = "simple_math";
    public final String description = "function for doing some simple math operations";
    public final String source = "test-functions";
    public final IdentifiedFunction.Category category = IdentifiedFunction.Category.UNASSIGNED;
    public final ArgumentList arguments = ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("a", (Type)Types.FLOATING), new FunctionArgument("b", (Type)Types.FLOATING), FunctionCallOptions.options(Options.class)});
    public final Type returnType = Types.FLOATING;

    public SimpleMathFunction(FunctionContext functionContext) {
    }

    public List<Type> getArgumentTypes() {
        return this.arguments.getArgumentTypes();
    }

    public Object call(List<Object> args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, final List<Type> givenTypes) {
        return ProblemException.catching(() -> {
            if (givenTypes.size() > this.arguments.size() || givenTypes.size() < this.arguments.size() - 1) {
                throw new ProblemException(new Problem[]{ArgsProblems.get().wrongNumberRange(this.arguments.size() - 1, this.arguments.size(), givenTypes.size())});
            }
            if (!((Type)givenTypes.get(0)).isNumeric()) {
                throw new ProblemException(new Problem[]{ArgsProblems.mismatch((FunctionArgument)this.arguments.get(0), (Type)((Type)givenTypes.get(0)))});
            }
            if (!((Type)givenTypes.get(1)).isNumeric()) {
                throw new ProblemException(new Problem[]{ArgsProblems.mismatch((FunctionArgument)this.arguments.get(1), (Type)((Type)givenTypes.get(1)))});
            }
            Options options = (Options)FunctionCallOptions.bindOptionsOrThrow(Options.class, (RealizationContext)context, (ArgumentList)this.arguments, (FunctionCall)functionCall);
            final BiFunction<Double, Double, Double> func = options.operation == Operation.ADD ? (a, b) -> a + b : (options.operation == Operation.SUBTRACT ? (a, b) -> a - b : (options.operation == Operation.MUTLIPLY ? (a, b) -> a * b : (a, b) -> a / b));
            return new RiskscapeFunction(){

                public List<Type> getArgumentTypes() {
                    return givenTypes;
                }

                public Type getReturnType() {
                    return Types.FLOATING;
                }

                public Object call(List<Object> args) {
                    Number a = (Number)args.get(0);
                    Number b = (Number)args.get(1);
                    return func.apply(a.doubleValue(), b.doubleValue());
                }
            };
        });
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSource() {
        return this.source;
    }

    public IdentifiedFunction.Category getCategory() {
        return this.category;
    }

    public ArgumentList getArguments() {
        return this.arguments;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public static class Options {
        @ParameterField
        public Operation operation = Operation.ADD;
    }

    public static enum Operation {
        ADD,
        SUBTRACT,
        MUTLIPLY,
        DIVIDE;

    }
}

