/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.gt;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.Envelope2D;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ArrayGridCoverage
extends AbstractGridCoverage {
    private final double[][] grid;
    private final Rectangle size;

    public ArrayGridCoverage(CharSequence name, CoordinateReferenceSystem crs, Rectangle size) {
        super(name, crs, null, null);
        if (size.x != 0 || size.y != 0) {
            throw new IllegalArgumentException("only grids set at (0,0) are supported");
        }
        this.grid = new double[size.height][size.width];
        this.size = size;
    }

    protected Rectangle getRectangle() {
        return this.size;
    }

    public GridGeometry getGridGeometry() {
        Rectangle gridRectangle;
        Rectangle userRectangle = gridRectangle = this.getRectangle();
        return new GridGeometry2D(gridRectangle, (Rectangle2D)userRectangle);
    }

    public int[] getOptimalDataBlockSizes() {
        throw new RuntimeException("Not implemented");
    }

    public RenderedImage getRenderedImage() {
        throw new RuntimeException("Not implemented");
    }

    public Envelope getEnvelope() {
        return new Envelope2D(this.crs, (Rectangle2D)this.getRectangle());
    }

    public void fill(Rectangle rectangle, double value) {
        for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                this.grid[y][x] = value;
            }
        }
    }

    public Object evaluate(DirectPosition point) throws PointOutsideCoverageException, CannotEvaluateException {
        double[] coordinate = point.getCoordinate();
        int x = (int)coordinate[0];
        int y = (int)coordinate[1];
        if (y >= this.grid.length) {
            throw new PointOutsideCoverageException();
        }
        double[] row = this.grid[y];
        if (x >= row.length) {
            throw new PointOutsideCoverageException();
        }
        return new double[]{this.grid[y][x]};
    }

    public int getNumSampleDimensions() {
        return 0;
    }

    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return null;
    }
}

