/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.cli.BaseCliIntegrationTest;
import nz.org.riskscape.engine.cli.CommandEnv;
import nz.org.riskscape.engine.cli.CommandInput;
import nz.org.riskscape.engine.cli.CommandResult;
import nz.org.riskscape.engine.cli.CommandRunner;
import nz.org.riskscape.engine.cli.ProcessRunner;

public class ShellRunner
extends ProcessRunner
implements CommandRunner {
    private Path executable;

    public ShellRunner() {
        this(Paths.get(System.getenv().getOrDefault("RISKSCAPE_CLI_BIN", "riskscape"), new String[0]));
    }

    public ShellRunner(Path executable) {
        this.executable = executable;
    }

    @Override
    public CommandResult execute(CommandInput input) {
        List<String> inputList = input.toStream().collect(Collectors.toList());
        inputList.set(0, this.executable.toString());
        BaseCliIntegrationTest.ExecResult result = this.exec(Paths.get(".", new String[0]), inputList, Optional.empty());
        return CommandResult.builder().exitCode(result.retCode).stderr(result.stderr).stdout(result.stdout).build();
    }

    @Override
    public CommandEnv environment() {
        return new CommandEnv(Paths.get(".", new String[0]).toAbsolutePath());
    }
}

