/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.File;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nz.org.riskscape.engine.cli.BaseCliIntegrationTest;

public class RunParameters {
    private List<Map.Entry<String, String>> params = new LinkedList<Map.Entry<String, String>>();
    private BaseCliIntegrationTest test;

    public RunParameters(BaseCliIntegrationTest test) {
        this.test = test;
        this.clear();
    }

    public int size() {
        return this.params.size();
    }

    public Map.Entry<String, String> get(int ctr) {
        return this.params.get(ctr);
    }

    private RunParameters add(String key, String value) {
        if (key.trim().endsWith("=")) {
            key = key.substring(0, key.length() - 1);
        }
        AbstractMap.SimpleEntry<String, String> ret = new AbstractMap.SimpleEntry<String, String>(key, value);
        this.params.add(ret);
        return this;
    }

    public RunParameters add(String ... keys) {
        for (String key : keys) {
            this.add(key, (String)null);
        }
        return this;
    }

    public RunParameters addPath(String key, String ... pathP) throws RuntimeException {
        List<String> path = Arrays.asList(pathP);
        String pathS = String.join((CharSequence)File.separator, path);
        String value = pathS = pathS.replaceAll("//", "/");
        value = this.test.toRSDPath(value);
        this.add(key, value);
        return this;
    }

    public List<String> toList() {
        LinkedList<String> ret = new LinkedList<String>();
        for (Map.Entry<String, String> pair : this.params) {
            String key = pair.getKey();
            String val = pair.getValue();
            String curr = key;
            if (null != val) {
                curr = key + "=" + val;
            }
            ret.add(curr);
        }
        return ret;
    }

    public String toString() {
        return this.toList().toString();
    }

    public RunParameters addAll(RunParameters other) {
        this.params.addAll(other.params);
        return this;
    }

    public RunParameters clear() {
        this.params.clear();
        return this;
    }

    public BaseCliIntegrationTest getTest() {
        return this.test;
    }

    public void setTest(BaseCliIntegrationTest test) {
        this.test = test;
    }
}

