/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.cli.BaseCliIntegrationTest;
import nz.org.riskscape.engine.cli.Inputter;

public class ProcessRunner {
    protected BaseCliIntegrationTest.ExecResult exec(Path workDir, List<String> commandList, Optional<Inputter> inputter) {
        ProcessBuilder pbuilder = new ProcessBuilder(new String[0]);
        pbuilder.directory(workDir.toFile());
        BaseCliIntegrationTest.ExecResult result = new BaseCliIntegrationTest.ExecResult();
        System.out.println(commandList.stream().map(Object::toString).collect(Collectors.joining(" ")));
        pbuilder.command(commandList);
        try {
            Process process = pbuilder.start();
            inputter.ifPresent(i -> i.start(process.getOutputStream()));
            List<Thread> threads = Arrays.asList(this.capture(result, "stderr", process.getErrorStream()), this.capture(result, "stdout", process.getInputStream()), inputter.orElse(null));
            int retCode = process.waitFor();
            result.retCode = retCode;
            threads.forEach(t -> {
                try {
                    if (t != null) {
                        t.join();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected Thread capture(BaseCliIntegrationTest.ExecResult result, String streamName, InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Thread thread = new Thread(() -> {
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.err.println(String.format("[%s] %s", streamName, line));
                    result.addOutput(streamName, line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        thread.start();
        return thread;
    }
}

