/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class Inputter
extends Thread {
    private List<Step> steps = new ArrayList<Step>();
    private OutputStream outputStream;

    private Inputter(Step initial) {
        this.steps.add(initial);
    }

    public static Inputter initialDelay(int delay) {
        return new Inputter(os -> Thread.sleep(delay));
    }

    public Inputter line(String line) {
        this.steps.add(os -> {
            os.write(String.format("%s%n", line).getBytes());
            os.flush();
        });
        return this;
    }

    public Inputter delay(int delay) {
        this.steps.add(os -> Thread.sleep(delay));
        return this;
    }

    void start(OutputStream os) {
        this.outputStream = os;
        this.start();
    }

    @Override
    public void run() {
        try {
            for (Step step : this.steps) {
                step.apply(this.outputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static interface Step {
        public void apply(OutputStream var1) throws Exception;
    }
}

