/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import com.google.common.collect.ImmutableList;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.cli.BaseCliIntegrationTest;
import nz.org.riskscape.engine.cli.CommandEnv;
import nz.org.riskscape.engine.cli.CommandInput;
import nz.org.riskscape.engine.cli.CommandResult;
import nz.org.riskscape.engine.cli.CommandRunner;
import nz.org.riskscape.engine.cli.ProcessRunner;

public class DockerRunner
extends ProcessRunner
implements CommandRunner {
    private String imageTag = System.getenv().getOrDefault("RISKSCAPE_CLI_IMAGE", "riskscape-cli");

    @Override
    public CommandResult execute(CommandInput input) {
        String uid = this.fetchUid().toString();
        ImmutableList.Builder prefix = ImmutableList.builder();
        prefix.add((Object[])new String[]{"docker", "run"}).add((Object[])new String[]{"--user", uid}).add((Object[])new String[]{"-v", String.format("%s:/home/riskscape", Paths.get(".", new String[0]).toAbsolutePath())}).add((Object[])new String[]{"-w", "/home/riskscape"}).add((Object)"--network=riskscape-test");
        prefix.add((Object)this.imageTag);
        Iterator inputIterator = input.toStream().iterator();
        String next = (String)inputIterator.next();
        if (!next.equals("riskscape")) {
            prefix.add((Object)next);
        }
        prefix.addAll(inputIterator);
        BaseCliIntegrationTest.ExecResult result = this.exec(Paths.get("..", new String[0]), (List<String>)prefix.build(), Optional.empty());
        return CommandResult.builder().exitCode(result.retCode).stderr(result.stderr).stdout(result.stdout).build();
    }

    private Integer fetchUid() {
        BaseCliIntegrationTest.ExecResult result = this.exec(Paths.get(".", new String[0]), Arrays.asList("id", "-u"), Optional.empty());
        return Integer.valueOf(result.stdout.get(0).trim());
    }

    @Override
    public CommandEnv environment() {
        return new CommandEnv(Paths.get("/home/riskscape", new String[0]));
    }

    public void setImageTag(String imageTag) {
        this.imageTag = imageTag;
    }

    public String getImageTag() {
        return this.imageTag;
    }
}

