/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.util.List;
import nz.org.riskscape.engine.cli.CommandInput;

public class CommandResult {
    public final CommandInput input;
    public final Integer exitCode;
    public final List<String> stdout;
    public final List<String> stderr;

    public static CommandResultBuilder builder() {
        return new CommandResultBuilder();
    }

    public CommandResult(CommandInput input, Integer exitCode, List<String> stdout, List<String> stderr) {
        this.input = input;
        this.exitCode = exitCode;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public static class CommandResultBuilder {
        private CommandInput input;
        private Integer exitCode;
        private List<String> stdout;
        private List<String> stderr;

        CommandResultBuilder() {
        }

        public CommandResultBuilder input(CommandInput input) {
            this.input = input;
            return this;
        }

        public CommandResultBuilder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public CommandResultBuilder stdout(List<String> stdout) {
            this.stdout = stdout;
            return this;
        }

        public CommandResultBuilder stderr(List<String> stderr) {
            this.stderr = stderr;
            return this;
        }

        public CommandResult build() {
            return new CommandResult(this.input, this.exitCode, this.stdout, this.stderr);
        }

        public String toString() {
            return "CommandResult.CommandResultBuilder(input=" + this.input + ", exitCode=" + this.exitCode + ", stdout=" + this.stdout + ", stderr=" + this.stderr + ")";
        }
    }
}

