/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class CommandInput {
    public final String command;
    public final List<Option> options;
    public final Optional<CommandInput> prev;

    public static CommandInput command(String name) {
        return new CommandInput(name, Collections.emptyList(), Optional.empty());
    }

    public CommandInput option(@NonNull String name, Path value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.option(name, value.toAbsolutePath().toString());
    }

    public CommandInput option(@NonNull String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ArrayList<Option> newOptions = new ArrayList<Option>(this.options.size() + 1);
        newOptions.addAll(this.options);
        newOptions.add(new Option(name, Optional.ofNullable(value)));
        return new CommandInput(this.command, newOptions, this.prev);
    }

    public CommandInput options(@NonNull String name, String ... values) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ArrayList<Option> newOptions = new ArrayList<Option>(this.options.size() + values.length);
        newOptions.addAll(this.options);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            newOptions.add(new Option(name, Optional.ofNullable(value)));
        }
        return new CommandInput(this.command, newOptions, this.prev);
    }

    public CommandInput option(String name) {
        return this.option(name, (String)null);
    }

    public CommandInput subcommand(String name) {
        return new CommandInput(name, Collections.emptyList(), Optional.of(this));
    }

    public String toString() {
        return String.format("%s %s %s", this.prev.map(ci -> String.format(" %s", ci.toString())).orElse(""), this.command, this.options.stream().map(swch -> swch.toString()).collect(Collectors.joining(" ")));
    }

    public Stream<String> toStream() {
        Stream<String> thisOne = Stream.concat(Stream.of(this.command), this.options.stream().map(Option::toString));
        return this.prev.map(p -> Stream.concat(p.toStream(), thisOne)).orElse(thisOne);
    }

    public CommandInput subcommands(String ... subcommands) {
        return this.subcommands(Arrays.asList(subcommands));
    }

    public CommandInput subcommands(List<String> subcommands) {
        if (subcommands.size() == 0) {
            return this;
        }
        String next = subcommands.get(0);
        return this.subcommand(next).subcommands(subcommands.subList(1, subcommands.size()));
    }

    public CommandInput replaceOption(String name, String value) {
        ArrayList<Option> newOptions = new ArrayList<Option>(this.options.size());
        newOptions.addAll(this.options);
        newOptions.removeIf(opt -> opt.name.equals(name));
        newOptions.add(new Option(name, Optional.of(value)));
        return new CommandInput(this.command, newOptions, this.prev);
    }

    public CommandInput(String command, List<Option> options, Optional<CommandInput> prev) {
        this.command = command;
        this.options = options;
        this.prev = prev;
    }

    public static final class Option {
        public final String name;
        public final Optional<String> value;

        public String toString() {
            String valueString = this.value.map(v -> String.format("=%s", v)).orElse("");
            return String.format("%s%s", this.name, valueString);
        }

        public Option(String name, Optional<String> value) {
            this.name = name;
            this.value = value;
        }
    }
}

