/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import java.nio.file.Path;
import nz.org.riskscape.engine.cli.CliIntegrationTest;
import nz.org.riskscape.engine.cli.CommandEnv;
import nz.org.riskscape.engine.cli.CommandInput;
import nz.org.riskscape.engine.cli.CommandResult;
import nz.org.riskscape.engine.cli.CommandRunner;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={CliIntegrationTest.class})
public class BaseCliIntegrationTest2 {
    public static final String ENV_TEST_RUNNER_CLASS = "RISKSCAPE_CLI_TEST_RUNNER_CLASS";
    protected CommandRunner runner;

    @Before
    public void setupRunner() throws Exception {
        String className = this.getRunnerClassName();
        this.runner = (CommandRunner)Class.forName(className).newInstance();
    }

    protected String getRunnerClassName() {
        return System.getenv().getOrDefault(ENV_TEST_RUNNER_CLASS, "nz.org.riskscape.engine.cli.DockerRunner");
    }

    public CommandResult execute(CommandInput input) {
        return this.runner.execute(input);
    }

    public CommandInput defaultCommand() {
        Path homeDirectory = this.homeDir();
        return CommandInput.command("riskscape").option("-H", homeDirectory).option("--show-stacktrace");
    }

    protected Path homeDir() {
        return this.environment().sourceTree.resolve("src").resolve("test").resolve("homes").resolve(this.getClass().getSimpleName());
    }

    protected CommandEnv environment() {
        return this.runner.environment();
    }

    public CommandInput modelRunCommand(String template) {
        return this.defaultCommand().subcommands("model", "run").option(template);
    }
}

