/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import com.csvreader.CsvReader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.TemporaryDirectoryTestHelper;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.cli.CliIntegrationTest;
import nz.org.riskscape.engine.cli.Inputter;
import nz.org.riskscape.engine.cli.RunParameters;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={CliIntegrationTest.class})
public class BaseCliIntegrationTest
implements TemporaryDirectoryTestHelper {
    public static String uid;
    private static final String HOME_RISKSCAPE = "/home\\riskscape";
    private static final String OPT_RISKSCAPE_CLI = "/opt\\riskscape-cli";
    protected String riskscapeDir = Paths.get("..", "home").toAbsolutePath().toString();
    protected List<String> plugins = Arrays.asList(new String[0]);
    protected RunParameters params = new RunParameters(this);
    protected Path outputDir;
    protected Path mappedOutputDir;
    protected String dockerImageName = "riskscape-cli";

    protected Path getInstallDir() {
        if (OsUtils.isUnix()) {
            return Paths.get("/opt/riskscape-cli", new String[0]).toAbsolutePath();
        }
        throw new RuntimeException("Don't know install dir...");
    }

    @Before
    public void setup() throws Exception {
        this.sniffRiskscapeDir();
        this.dockerImageName = "riskscape-cli";
        this.outputDir = new File(this.riskscapeDir).toPath().resolve("output");
        File outDir = this.outputDir.toFile();
        if (!outDir.exists()) {
            Files.createDirectory(this.outputDir, new FileAttribute[0]);
        }
        if (!outDir.isDirectory()) {
            throw new RuntimeException("Out directory is not a directory");
        }
        this.mappedOutputDir = OsUtils.isUnix() ? Paths.get("/home", "riskscape", "output") : this.outputDir;
    }

    protected void sniffRiskscapeDir() {
        Path conventionalPath = Paths.get("src", "test", "homes", this.getClass().getSimpleName());
        if (conventionalPath.toFile().exists()) {
            this.riskscapeDir = conventionalPath.toAbsolutePath().toString();
        }
    }

    @After
    public void cleanup() throws Exception {
        if (this.outputDir != null) {
            this.remove(this.outputDir);
        }
    }

    protected String expand(String string) {
        return new File(string).getAbsolutePath();
    }

    protected Path testdir(String segment) {
        return Paths.get("src", "test", "homes", segment).toAbsolutePath();
    }

    protected ExecResult execute(RunParameters extra) {
        return this.doExecute(Optional.empty(), extra);
    }

    protected ExecResult execute(Optional<Inputter> inputter, RunParameters extra) {
        return this.doExecute(inputter, extra);
    }

    private ExecResult doExecute(Optional<Inputter> inputter, RunParameters extra) {
        if (!new File(this.riskscapeDir).exists()) {
            Assert.fail((String)("riskscapeDir: " + this.riskscapeDir + " does not exist"));
        }
        RunParameters prefix = new RunParameters(this);
        if (OsUtils.isUnix()) {
            if (uid == null) {
                this.fetchUid();
            }
            prefix.add("docker").add("run").add(new String[]{"--user", uid}).addPath("-v", this.riskscapeDir, ":", "/home", "riskscape").addPath("-w", "/home", "riskscape").add("--network=riskscape-test");
            inputter.ifPresent(i -> prefix.add("--interactive"));
            prefix.add(this.dockerImageName).addPath("-b", "/home", "riskscape").add("--show-stacktrace");
        } else {
            Path rsd = Paths.get(this.riskscapeDir, new String[0]);
            String rsds = rsd.toAbsolutePath().toString();
            String dotbat = Paths.get("..", "cli", "build", "install", "riskscape", "bin", "riskscape.bat").toAbsolutePath().toString();
            prefix.add(dotbat).add("-b=" + rsds).add("--show-stacktrace");
        }
        for (String pluginJar : this.plugins) {
            if (OsUtils.isUnix()) {
                prefix.add("-l").add(Paths.get("/opt", "riskscape-cli", "plugins", pluginJar).toAbsolutePath().toString());
                continue;
            }
            prefix.addPath("-l", "/opt", "riskcape-cli", "plugins", pluginJar);
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.addAll(prefix.toList());
        commandList.addAll(extra.toList());
        return this.exec(Paths.get("..", new String[0]), commandList, inputter);
    }

    protected ExecResult exec(Path workDir, List<String> commandList, Optional<Inputter> inputter) {
        ProcessBuilder pbuilder = new ProcessBuilder(new String[0]);
        pbuilder.directory(workDir.toFile());
        ExecResult result = new ExecResult();
        System.out.println(commandList.stream().map(Object::toString).collect(Collectors.joining(" ")));
        pbuilder.command(commandList);
        try {
            Process process = pbuilder.start();
            inputter.ifPresent(i -> i.start(process.getOutputStream()));
            List<Thread> threads = Arrays.asList(this.capture(result, "stderr", process.getErrorStream()), this.capture(result, "stdout", process.getInputStream()), inputter.orElse(null));
            int retCode = process.waitFor();
            result.retCode = retCode;
            threads.forEach(t -> {
                try {
                    if (t != null) {
                        t.join();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void fetchUid() {
        ExecResult result = this.exec(Paths.get(".", new String[0]), Arrays.asList("id", "-u"), Optional.empty());
        uid = result.stdout.get(0).trim();
    }

    protected Thread capture(ExecResult result, String streamName, InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Thread thread = new Thread(() -> {
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.err.println(String.format("[%s] %s", streamName, line));
                    result.addOutput(streamName, line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        thread.start();
        return thread;
    }

    protected List<Tuple> parseOutput(ExecResult result, Struct type) {
        EnumSet<Tuple.CoerceOptions> options = EnumSet.of(Tuple.CoerceOptions.SURPLUS_IGNORED, Tuple.CoerceOptions.MISSING_IGNORED);
        return result.stdout.stream().map(str -> Tuple.coerce((Struct)type, (Map)new JSONObject(str).toMap(), (EnumSet)options)).collect(Collectors.toList());
    }

    protected List<Map<String, Object>> parseJsonFromOutput(String ... pathElements) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(this.outputDir.toString(), pathElements));
        return lines.stream().map(line -> new JSONObject(line).toMap()).collect(Collectors.toList());
    }

    protected List<Map<String, String>> parseCsv(ExecResult result) throws IOException {
        CsvReader reader = new CsvReader((Reader)new StringReader(result.stdout.stream().collect(Collectors.joining("\n"))));
        reader.readHeaders();
        ArrayList rows = Lists.newArrayList();
        List<String> header = Arrays.asList(reader.getHeaders());
        while (reader.readRecord()) {
            List<String> values = Arrays.asList(reader.getValues());
            rows.add(ImmutableMap.copyOf((Iterable)Streams.zip(header.stream(), values.stream(), (a, b) -> new AbstractMap.SimpleImmutableEntry<String, String>((String)a, (String)b)).collect(Collectors.toList())));
        }
        return rows;
    }

    protected void assertOutputExists(String ... pathElements) {
        Path path = Paths.get(this.outputDir.toString(), pathElements);
        Assert.assertTrue((String)("Expected output directory to contain " + path.toString()), (boolean)path.toFile().exists());
    }

    protected void assertFileHasLines(List<String> subsetOfExpectedRows, Path outfile) throws IOException {
        ArrayList<String> working = new ArrayList<String>(subsetOfExpectedRows);
        this.forEachLineInFile(outfile, line -> working.remove(line));
        if (!working.isEmpty()) {
            Assert.fail((String)String.format("Expected %s to contain these rows: %s", outfile, working));
        }
    }

    protected void forEachLineInFile(Path outfile, Consumer<String> consumer) throws IOException {
        try (BufferedReader reader = this.createBufferedReader(outfile);){
            String line;
            while ((line = reader.readLine()) != null) {
                consumer.accept(line);
            }
        }
    }

    protected BufferedReader createBufferedReader(Path outfile) throws IOException {
        return new BufferedReader(new FileReader(outfile.toFile()));
    }

    protected void assertHasLineCount(int i, Path outfile) throws IOException {
        int[] counter = new int[]{0};
        this.forEachLineInFile(outfile, l -> {
            counter[0] = counter[0] + 1;
        });
    }

    protected void assertHasRecords(Map<String, List<String>> expected, Path csv, String keyColumn, String ... valueKeys) throws IOException {
        this.assertHasRecords(expected, this.createBufferedReader(csv), keyColumn, valueKeys);
    }

    protected void assertHasRecords(Map<String, List<String>> expected, Reader csv, String keyColumn, String ... valueKeys) throws IOException {
        CsvReader reader = new CsvReader(csv);
        reader.setSafetySwitch(false);
        reader.readHeaders();
        while (reader.readRecord()) {
            String key = reader.get(keyColumn);
            if (!expected.containsKey(key)) continue;
            List<String> expectedValues = expected.get(key);
            List actualValues = Arrays.asList(valueKeys).stream().map(k -> {
                try {
                    return reader.get(k);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            Assert.assertEquals(expectedValues, actualValues);
        }
    }

    protected String toRSDPath(String dockerPath) {
        String ret = dockerPath;
        if (OsUtils.isWindows()) {
            if (dockerPath.matches(Pattern.quote(HOME_RISKSCAPE) + ".*")) {
                ret = dockerPath.replace(HOME_RISKSCAPE, this.riskscapeDir);
            } else if (dockerPath.matches(Pattern.quote(OPT_RISKSCAPE_CLI) + ".*")) {
                ret = dockerPath.replace(OPT_RISKSCAPE_CLI, "..\\cli\\build\\install\\riskscape");
                ret = new File(ret).getAbsolutePath();
            } else {
                ret = this.riskscapeDir + File.separator + dockerPath;
            }
        }
        return ret;
    }

    protected Tuple wrapAsLoss(Tuple toWrap) {
        return Tuple.of((Struct)Struct.of((String)"loss", (Type)toWrap.getStruct()), (String)"loss", (Object)toWrap);
    }

    public static class ExecResult
    implements TemporaryDirectoryTestHelper {
        public Process process;
        public Integer retCode;
        public List<String> allOutput = Collections.synchronizedList(Lists.newArrayList());
        public List<String> stdout = new ArrayList<String>();
        public List<String> stderr = new ArrayList<String>();

        public void addOutput(String streamName, String line) {
            if (streamName.equals("stdout")) {
                this.stdout.add(line);
            }
            if (streamName.equals("stderr")) {
                this.stderr.add(line);
            }
            this.allOutput.add(line);
        }
    }
}

