/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Formatter;

public interface TemporaryDirectoryTestHelper {
    default public Path createTempDirectory(String prefix) throws IOException {
        return Files.createTempDirectory(prefix, new FileAttribute[0]);
    }

    default public void remove(Path directory) throws Exception {
        if (!Files.exists(directory, new LinkOption[0])) {
            return;
        }
        Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    default public Path writeFile(String named, Path directory, String ... lines) throws IOException {
        Path toWrite = directory.resolve(named);
        try (FileWriter fw = new FileWriter(toWrite.toFile());
             Formatter f = new Formatter(fw);){
            for (String line : lines) {
                f.format("%s%n", line);
            }
        }
        return toWrite;
    }
}

