/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import nz.org.riskscape.engine.Problem;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsSame;

public class Matchers {
    public static Matcher<Problem> isProblem(Problem.Severity severity, Matcher<String> messageMatcher) {
        return Matchers.isProblem((Matcher<Problem.Severity>)new IsSame((Object)severity), messageMatcher);
    }

    public static Matcher<Problem> isProblem(final Matcher<Problem.Severity> severity, final Matcher<String> messageMatcher) {
        return new TypeSafeMatcher<Problem>(){

            public void describeTo(Description description) {
                description.appendText("Problem");
                description.appendDescriptionOf((SelfDescribing)severity);
                description.appendDescriptionOf((SelfDescribing)messageMatcher);
            }

            protected boolean matchesSafely(Problem item) {
                return severity.matches((Object)item.getSeverity()) && messageMatcher.matches((Object)item.getMessage());
            }
        };
    }

    public static Matcher<Problem> isProblem(final Class<? extends Throwable> expectedError) {
        return new TypeSafeMatcher<Problem>(){

            public void describeTo(Description description) {
                description.appendText("Problem with error of type " + expectedError);
            }

            protected boolean matchesSafely(Problem item) {
                return expectedError.isInstance(item.error);
            }
        };
    }
}

