/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public interface CrsHelper {
    default public CoordinateReferenceSystem nzTransverseMercator() {
        return this.fromClassPathResource("/nz/org/riskscape/engine/crs/EPSG27200.wkt");
    }

    default public CoordinateReferenceSystem latLong() {
        return this.fromClassPathResource("/nz/org/riskscape/engine/crs/EPSG4326.wkt");
    }

    default public CoordinateReferenceSystem fromClassPathResource(String classpath) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(classpath);
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            return CRS.parseWKT((String)builder.toString());
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }
}

