/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Tuple;

public class Assert {
    public static <T extends Throwable> T assertThrows(Class<T> clazz, Thrower thrower) {
        try {
            thrower.run();
        }
        catch (Throwable ex) {
            if (clazz.isInstance(ex)) {
                return (T)((Throwable)clazz.cast(ex));
            }
            throw new RuntimeException("Should have raised exception of type " + clazz + " but was " + ex.getClass(), ex);
        }
        org.junit.Assert.fail((String)"Should have raised an exception");
        return null;
    }

    public static <T> void assertInstanceOf(Class<T> desiredType, Object actual, Consumer<T> callback) {
        if (desiredType.isInstance(actual)) {
            callback.accept(desiredType.cast(actual));
        } else {
            Class<?> actualType = actual == null ? null : actual.getClass();
            org.junit.Assert.fail((String)("Expected " + actual + " to be of type " + desiredType + " but was " + actualType));
        }
    }

    public static void assertContains(List<String> output, String toMatch) {
        org.junit.Assert.assertTrue((String)String.format("Expected output to contain string '%s'\n%s", toMatch, output), (boolean)output.stream().filter(line -> line.contains(toMatch)).findAny().isPresent());
    }

    public static void assertContains(List<Tuple> results, Tuple expected) {
        Optional<Tuple> found = results.stream().filter(t -> t.equals((Object)expected)).findFirst();
        if (!found.isPresent()) {
            org.junit.Assert.fail((String)String.format("Expected list to contain %s:\n%s", expected, results));
        }
    }

    public static void refuteContains(List<String> output, String toMatch) {
        org.junit.Assert.assertFalse((String)String.format("Did not expect output to contain string '%s'\n%s", toMatch, output), (boolean)output.stream().filter(line -> line.contains(toMatch)).findAny().isPresent());
    }

    public static void assertMatchesSomewhere(List<String> output, String regexToMatch) {
        Pattern regex = Pattern.compile(regexToMatch);
        org.junit.Assert.assertTrue((String)String.format("Expected to find %s among output:\n%s", regexToMatch, output.stream().collect(Collectors.joining("\n"))), (boolean)output.stream().filter(line -> regex.matcher((CharSequence)line).find()).findAny().isPresent());
    }

    public static void assertMatches(List<String> output, String regexToMatch) {
        org.junit.Assert.assertTrue((String)String.format("Expected to find %s among output:\n%s", regexToMatch, output.stream().collect(Collectors.joining("\n"))), (boolean)output.stream().filter(line -> line.matches(regexToMatch)).findAny().isPresent());
    }

    public static void assertNoMatches(List<String> output, String regexToMatch) {
        org.junit.Assert.assertFalse((boolean)output.stream().filter(line -> line.matches(regexToMatch)).findAny().isPresent());
    }

    public static void assertStringContains(String expected, String entireString) {
        org.junit.Assert.assertTrue((String)String.format("Expected '%s' to contain '%s'", entireString, expected), (boolean)entireString.contains(expected));
    }

    public static void assertListEquals(List expected, List found) {
        org.junit.Assert.assertEquals((String)"Lists are not the same size", (long)expected.size(), (long)found.size());
        for (int i = 0; i < expected.size(); ++i) {
            org.junit.Assert.assertEquals((String)String.format("List element at index %d is not as expected", i), expected.get(i), found.get(i));
        }
    }

    public static interface Thrower {
        public void run() throws Exception;
    }
}

